package examples.templateMethod.aspectj;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.pattern.
 *
 * Contributor(s):   
 */

/**
 * Defines the interface for creators. In this example, it acts as the <i>
 * AbstractClass</i>. The template method is <code>decorate(String)</code>,
 * which uses all other methods defined in this abstract class.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 * @see SimpleCreator
 * @see FancyCreator
 */

public interface Creator { 
	                        
	//public String decorate(String s); Attached by aspect!

    /**
     * Prepares a string for decoration.
     *
     * @param s the string to filter
     * @returns the prepared string
     */

	public String prepare  (String s);

    /**
     * Filters a string. 
     *
     * @param s the string to filter
     * @returns the filtered string
     */

	public String filter   (String s);

    /**
     * Finalizes a string. This is the last step in the template method.
     *
     * @param s the string to finalize
     * @returns the finalized string
     */

	public String finalize (String s);
}
	
		
		