package examples.proxy.java;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

/**
 * Implements a <i>Proxy</i> according to GoF. It implements the
 * <i>Subject</i> interface as <i>RealSubject</i> does.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 * @see Subject
 * @see Proxy
 */  

public class Proxy implements Subject { 
    
    /**
     * a reference to the RealSubject for method forwarding
     */
     
	private Subject realSubject; 
	
	/**
	 * An internal counter for the number of calls to <code>
	 * print(String)</code>.
	 */
	 
	private int printCalls = 0;
	
    /**
     * Creates a new <i>Proxy</i> with the given <i>RealSubject</i>.
     *
     * @param subject The <i>RealSubject</i> to forward method calls to
     */

	public Proxy(Subject subject) {
		this.realSubject = subject;
	}
	
    /**
     * Prints the argument string to <code>System.out</code>. This is 
     * equivalent to <code>write(String)</code>
     *
     * @param s the string to print
     */
     
	public void print(String s) {
		printCalls++;
		realSubject.print(s);                                                
		System.out.println("[Proxy:] That was call "+printCalls+" to Subject.print(String)");		
	}
	
    /**
     * Prints the argument string to <code>System.out</code>. This is 
     * equivalent to <code>print(String)</code>
     *
     * @param s the string to print
     */

	public void write(String s) {
		realSubject.write(s);                                                
		System.out.println("[Proxy:] Not interested in write calls, but must implement anyway");		
	}
	
}