package examples.memento.java;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

/**
 * Implements a sample <i>Memento</i> class. This particular menento stores
 * the counter of its originator (an int value), and returns it upon request.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 07/13/02
 * 
 * @see Originator
 */

public class Memento {         
	
    /**
     * stores the originator's state
     */

	private int state;
	
    /**
     * Captures the originator's state and stores it
     *
     * @param newState the state to store
     */

	public void setState(int newState) { 
	    state = newState; 
	}
	
    /**
     * Returns the stored originator state
     *
     * @returns the stored state
     */

	public int  getState() { 
	    return state; 
	}  
	
    /**
     * Creates a memento object specifically designed for this example
     *
     * @param init the initial state to store
     */

	public Memento(int init) {
		state = init;
	}
}