package examples.memento.java;


/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

/**
 * Implements a sample <i>Originator</i> class. Objects of this particular 
 * originator have stat: an int representing the number of time the <code>
 * increment()</code> method was called.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 07/13/02
 * 
 * @see Memento
 */

public class Originator {
     
    /**
     * the number of times <code>increment()</code> was called on this object
     */

	protected int currentValue = 0;
	
    /**
     * increments the counter (this originator's state) by one
     */

	public void increment() { 
	    currentValue++; 
	}
	
    /**
     * Displays a the state of this originator
     */

	public void show() { 
	    System.out.println("Originator value is " + currentValue); 
	}  
	
    /**
     * Creates a memento from this originator, storing the current state
     */

	public Memento createMemento() { 
	    return new Memento(currentValue); 
	}
	
    /**
     * Restores this originator to former state stored by the memento passed
     *
     * @param m the memento that stores the prior state
     */

	public void setMemento(Memento m) { 
	    currentValue = m.getState(); 
	}
}