package examples.flyweight.aspectj;  

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */
 
import ca.ubc.cs.spl.pattern.library.FlyweightProtocol;

/**
 * Implements a concrete instance of the flyweight pattern. 
 *
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 */


public aspect FlyweightImplementation extends FlyweightProtocol {
	
    /** 
     * Assigns  the <i>Flyweight</i> role to CharacterFlyweight.
     */

	declare parents: CharacterFlyweight	 implements Flyweight;

    /** 
     * Assigns  the <i>Flyweight</i> role to WhitespaceFlyweight.
     */

	declare parents: WhitespaceFlyweight implements Flyweight;

    /**
     * Actually creates the flyweight for a key. This method is called by
     * <code>getFlyweight(Object)</code> if the flyweight does not already
     * exist.
     *
     * @param key the key identifying the particular flyweight
     * @returns the flyweight representing the key
     */

	protected Flyweight createFlyweight(Object key) {
		char c = ((Character) key).charValue(); 
		Flyweight flyweight = null;
		if (Character.isWhitespace(c)) {
			flyweight = new WhitespaceFlyweight(c);
		} else { 
			flyweight = new CharacterFlyweight(c);
		}
		return flyweight; 
	}  
	
    /**
     * Provides a custom interface to access the flyweights. Refers to the 
     * general <code>getFlyweight(Object)</code> method defined on the
     * abstract aspect.
     *
     * @param c the character identifying the particular flyweight
     * @returns the flyweight representing the character
     */

	public PrintableFlyweight getPrintableFlyweight(char c) {
		Character ch = new Character(c); 
		return (PrintableFlyweight) getFlyweight(ch);
	}
}