package examples.composite.java;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.pattern.
 *
 * Contributor(s):   
 */
 
/**
 * Implements a <i>Leaf</i>. Leafs have no children.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 * @see Component 
 * @see CompositeA
 */

public class LeafB implements Component {

    /**
     * stores an ID for this composite
     */

	protected int id = 0;
	
    /**
     * Creates a new CompositeA with a given ID
     *
     * @param id the ID for the new object
     */

	public LeafB(int id) {
		this.id = id;
	}
	 
    /**
     * Overwrites the <code>toString()</code> method from <code>Object</code>
     * to print information about this object
     */

	public String toString() {
		return ("I am B (ID "+id+")");
	}
 
 
    /**
     * Adds a child to the component
     *
     * @param component the child to add
     */

	public void	 add(Component component)    {}

    /**
     * Adds a child to the component
     *
     * @param component the child to add
     */

	public void	 remove(Component component) {}

    /**
     * Returns a child of the component
     *
     * @param index the position of the child
     */
     
	public Component getChild(int index)         {return null;}

    /**
     * Returns the number of chilren a component has
     *
     * @returns the number of children of this component
     */
 
	public int	 getChildCount()             {return 0;}
}
