package examples.builder.aspectj;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.pattern.
 *
 * Contributor(s):   
 */

/**
 * Implements a <i>ConcreteBuilder</i> that builds textual descriptions
 * of complex objects consisting of type, attributes and values. This verison
 * makes use of the default implementation of <code>getResult()</code>.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 */

public class TextBuilder implements Builder {

    /** 
     * Defines the <i>buildPart()</i> operation for type parts.
     *
     * @param type the type to process
     */ 

    public void processType(String type) {
        result = "This is a new "+type+":\n";
    }
    
    /** 
     * Defines the <i>buildPart()</i> operation for attribute parts.
     *
     * @param type the type to process
     */ 

    public void processAttribute(String attribute) {
        result += ("Its " + attribute + " is ");
    }
    
    /** 
     * Defines the <i>buildPart()</i> operation for value parts.
     *
     * @param type the type to process
     */ 

    public void processValue(String type) {
        result += (type + ".\n");
    }
}  
