/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.sprites;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.CAS;
import vgrazi.concurrent.samples.sprites.ConcurrentAnimationEvent;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class ConcurrentSpriteCanvas
extends JPanel {
    private static long DELAY = 20L;
    static int DELTA = 5;
    static int BACK_DELTA = 15;
    private static final int ARROW_LENGTH = 5;
    private static final int RADIUS = 5;
    private int ARROW_DELTA = 20;
    private int rightBorder = 2;
    private int topBorder = 2;
    private int topOffset = 30;
    private int leftOffset = 0;
    private static final int ACQUIRE_BORDER_WORKING = 175;
    private static final int RELEASE_BORDER_WORKING = 225;
    private static final int ACQUIRE_BORDER_BLOCKING = 130;
    private static final int RELEASE_BORDER_BLOCKING = 230;
    public static int ACQUIRE_BORDER;
    public static int RELEASE_BORDER;
    private ScheduledExecutorService clock;
    private Queue<ConcurrentSprite> sprites = new ConcurrentLinkedQueue<ConcurrentSprite>();
    private ConcurrentExample concurrentExample;
    private String labelText;
    static ExampleType exampleType;
    private final int BORDER = 5;
    private final int deltaY = this.ARROW_DELTA - 5;
    private int NEXT_LOCATION;
    private static final int VERTICAL_ARROW_DELTA = 45;
    private final FontMetrics fontMetrics;
    private int verticalIndex;
    private final PropertyChangeSupport PROPERTY_CHANGE_SUPPORT = new PropertyChangeSupport(this);

    public ConcurrentSpriteCanvas(ConcurrentExample concurrentExample, String string) {
        this.setFont(ConcurrentExampleConstants.MUTEX_HEADER_FONT);
        this.concurrentExample = concurrentExample;
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.setLabelText(string);
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.resumeClock();
    }

    public void togglePauseResume() {
        if (this.clock.isShutdown()) {
            this.resumeClock();
        } else {
            this.pause();
        }
    }

    public void resumeClock() {
        if (this.clock == null || this.clock.isShutdown()) {
            this.clock = new ScheduledThreadPoolExecutor(1);
            this.clock.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ConcurrentSpriteCanvas.this.repaint();
                }
            }, 0L, DELAY, TimeUnit.MILLISECONDS);
        }
    }

    private void pause() {
        if (!this.clock.isShutdown()) {
            this.clock.shutdownNow();
        }
    }

    public static int getTimeToAcquireBorder() {
        return (int)(1.5 * (double)ACQUIRE_BORDER / (double)((float)DELTA / (float)DELAY));
    }

    public void setLabelText(String string) {
        this.labelText = string;
    }

    public void setExampleType(ExampleType exampleType) {
        ConcurrentSpriteCanvas.exampleType = exampleType;
        switch (ConcurrentSpriteCanvas.exampleType) {
            case CAS: {
                DELTA = 3;
                BACK_DELTA = 0;
                this.topBorder += 30;
                int n = 80;
                ACQUIRE_BORDER = 130 + n;
                RELEASE_BORDER = 230 + n + 10;
                break;
            }
            case BLOCKING: 
            case PLURAL: 
            case ONE_USE: {
                ACQUIRE_BORDER = 130;
                RELEASE_BORDER = 230;
                break;
            }
            case WORKING: {
                ACQUIRE_BORDER = 175;
                RELEASE_BORDER = 225;
            }
        }
    }

    public void addSprite(ConcurrentSprite concurrentSprite) {
        this.sprites.add(concurrentSprite);
    }

    public int getSpriteCount() {
        return this.sprites.size();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.fill3DRect(0, 0, 1500, 2000, true);
        Dimension dimension = this.getSize();
        for (ConcurrentSprite concurrentSprite : this.sprites) {
            if (concurrentSprite.getCurrentLocation() > dimension.width - this.rightBorder) {
                this.sprites.remove(concurrentSprite);
                this.concurrentExample.spriteRemoved(concurrentSprite);
                continue;
            }
            if (!concurrentSprite.isRejected() || concurrentSprite.getCurrentLocation() >= 0) continue;
            this.sprites.remove(concurrentSprite);
        }
        this.drawMutex(graphics2D, dimension);
        graphics2D.setColor(ConcurrentExampleConstants.MUTEX_FONT_COLOR);
        graphics2D.drawString(this.labelText, (ACQUIRE_BORDER + RELEASE_BORDER) / 2 + this.leftOffset - this.fontMetrics.stringWidth(this.labelText) / 2, this.topOffset - 10);
        try {
            for (ConcurrentSprite concurrentSprite : this.sprites) {
                int n = concurrentSprite.getIndex();
                ConcurrentSprite.SpriteState spriteState = concurrentSprite.getState();
                int n2 = concurrentSprite.getCurrentLocation() + this.leftOffset;
                int n3 = n * this.ARROW_DELTA + this.topBorder + this.topOffset;
                graphics2D.setColor(concurrentSprite.getColor());
                switch (spriteState) {
                    case ACQUIRING: 
                    case ACQUIRED: 
                    case ACTION_COMPLETED: {
                        this.drawAcquiring(graphics2D, n2, n3, concurrentSprite);
                        break;
                    }
                    case REJECTED: {
                        this.drawRejected(graphics2D, n2, n3, concurrentSprite);
                        break;
                    }
                    case RELEASED: {
                        if (concurrentSprite.getCurrentLocation() < ACQUIRE_BORDER) {
                            this.drawAcquiring(graphics2D, n2, n3, concurrentSprite);
                            break;
                        }
                        this.drawReleased(graphics2D, n2, n3, concurrentSprite);
                        break;
                    }
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            System.out.println("ConcurrentSpriteCanvas.paint " + concurrentModificationException);
        }
    }

    private void drawMutex(Graphics2D graphics2D, Dimension dimension) {
        graphics2D.setColor(ConcurrentExampleConstants.MUTEX_BACKGROUND);
        switch (exampleType) {
            case CAS: {
                graphics2D.fill3DRect(ACQUIRE_BORDER + this.leftOffset, this.topOffset, RELEASE_BORDER - ACQUIRE_BORDER + this.leftOffset, dimension.height - 20 - this.topOffset, true);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n = fontMetrics.stringWidth(String.valueOf(CAS.getValue()));
                int n2 = fontMetrics.getHeight();
                graphics2D.setColor(ConcurrentExampleConstants.CAS_CIRCLE_COLOR);
                int n3 = ACQUIRE_BORDER + this.leftOffset + (RELEASE_BORDER - ACQUIRE_BORDER + this.leftOffset - n) / 2;
                int n4 = this.topOffset + n2 - 10;
                graphics2D.drawString(String.valueOf(CAS.getValue()), n3, n4);
                break;
            }
            case BLOCKING: {
                graphics2D.fill3DRect(ACQUIRE_BORDER + this.leftOffset, this.topOffset, RELEASE_BORDER - ACQUIRE_BORDER + this.leftOffset, dimension.height - 20 - this.topOffset, true);
                break;
            }
            case WORKING: {
                graphics2D.fill3DRect(ACQUIRE_BORDER + this.leftOffset, this.topOffset, RELEASE_BORDER - ACQUIRE_BORDER + this.leftOffset + 10, dimension.height - 20 - this.topOffset, true);
                break;
            }
            case PLURAL: 
            case ONE_USE: {
                int n = dimension.height - 20 - this.topOffset;
                if (exampleType == ExampleType.PLURAL) {
                    for (int i = this.topOffset + this.ARROW_DELTA * 3 / 4; i <= n; i += this.deltaY + 5) {
                        graphics2D.fill3DRect(ACQUIRE_BORDER + this.leftOffset, i, RELEASE_BORDER - ACQUIRE_BORDER + this.leftOffset, this.deltaY, true);
                    }
                    break;
                }
                if (exampleType != ExampleType.ONE_USE) break;
                if (this.NEXT_LOCATION == 0) {
                    this.NEXT_LOCATION = this.topOffset + this.ARROW_DELTA * 3 / 4 + (this.deltaY + 5) * this.verticalIndex;
                }
                graphics2D.fill3DRect(ACQUIRE_BORDER + this.leftOffset, this.NEXT_LOCATION, RELEASE_BORDER - ACQUIRE_BORDER + this.leftOffset, this.deltaY, true);
            }
        }
    }

    public void bumpVerticalMutexIndex() {
        ++this.verticalIndex;
        this.NEXT_LOCATION += this.deltaY + 5;
        if (this.NEXT_LOCATION >= this.getSize().height - 100) {
            this.resetMutexVerticalIndex();
        }
    }

    public void resetMutexVerticalIndex() {
        this.verticalIndex = 0;
        this.NEXT_LOCATION = 0;
        if (exampleType == ExampleType.CAS) {
            this.bumpVerticalMutexIndex();
        }
    }

    private void drawReleased(Graphics2D graphics2D, int n, int n2, ConcurrentSprite concurrentSprite) {
        switch (concurrentSprite.getType()) {
            case ARROW: 
            case CAS: {
                int n3;
                int n4;
                int n5;
                if (concurrentSprite.getType() == ConcurrentSprite.SpriteType.CAS) {
                    n5 = n2;
                    n4 = n2 - 5;
                    n3 = n2 + 5;
                    graphics2D.drawLine(n, n5, n - 20, n4);
                    graphics2D.drawLine(n, n5, n - 20, n3);
                    int n6 = 15;
                    graphics2D.drawLine(n, n5, n - n6 * 6, n5);
                    n5 = n2 - 5 + 5;
                    graphics2D.setColor(ConcurrentExampleConstants.CAS_ANIMATION_COLOR);
                } else {
                    n5 = n2 - 5;
                    if (exampleType == ExampleType.ONE_USE) {
                        n5 += this.NEXT_LOCATION - 45;
                    }
                    graphics2D.fillOval(n - 5, n5, 10, 10);
                    n5 = n2;
                    if (exampleType == ExampleType.ONE_USE) {
                        n5 += this.NEXT_LOCATION - 45;
                    }
                    graphics2D.drawLine(n, n5, n - 30, n5);
                }
                n4 = concurrentSprite.getExpectedValue();
                n3 = concurrentSprite.getValue();
                if (n4 != ConcurrentSprite.NO_VALUE) {
                    graphics2D.setColor(ConcurrentExampleConstants.CAS_ANIMATION_COLOR);
                    graphics2D.drawString("(" + n4 + ")", n - 55, n5);
                }
                if (n3 == ConcurrentSprite.NO_VALUE) break;
                graphics2D.setColor(ConcurrentExampleConstants.CAS_ANIMATION_COLOR);
                graphics2D.drawString(String.valueOf(n3), n - 55, n5);
                break;
            }
            case OVAL: {
                int n7 = n2;
                if (exampleType == ExampleType.ONE_USE) {
                    n7 += this.NEXT_LOCATION - 45;
                }
                graphics2D.fillOval(n - 85, n7, 90, 10);
            }
        }
        concurrentSprite.bumpCurrentLocation(DELTA);
    }

    private void drawRejected(Graphics2D graphics2D, int n, int n2, ConcurrentSprite concurrentSprite) {
        int n3 = n2;
        if (exampleType == ExampleType.ONE_USE) {
            n3 += this.NEXT_LOCATION - 45;
        }
        switch (concurrentSprite.getType()) {
            case ARROW: 
            case CAS: {
                int n4 = 10;
                if (exampleType == ExampleType.ONE_USE) {
                    n4 += this.NEXT_LOCATION - 45;
                }
                if (concurrentSprite.getType() == ConcurrentSprite.SpriteType.CAS) {
                    graphics2D.fillOval(n - 5 - 90 - 5 - 1, n2 - 5, n4, 10);
                    graphics2D.drawLine(n, n3, n - 90, n3);
                    graphics2D.setColor(ConcurrentExampleConstants.CAS_ANIMATION_COLOR);
                    int n5 = concurrentSprite.getValue();
                    if (n5 != ConcurrentSprite.NO_VALUE) {
                        graphics2D.drawString(String.valueOf(n5), n - 90, n3);
                    }
                } else {
                    graphics2D.fillOval(n - 5 - 30, n2 - 5, n4, 10);
                    graphics2D.drawLine(n, n3, n - 30, n3);
                }
                graphics2D.drawLine(n, n3, n - 30, n3);
                break;
            }
            case OVAL: {
                graphics2D.fillOval(n - 85, n3, 90, 10);
            }
        }
        concurrentSprite.kickCurrentLocation(DELTA);
    }

    private void drawAcquiring(Graphics2D graphics2D, int n, int n2, ConcurrentSprite concurrentSprite) {
        switch (concurrentSprite.getType()) {
            case ARROW: 
            case CAS: {
                int n3;
                int n4 = n2;
                int n5 = n2 - 5;
                int n6 = n2 + 5;
                if (exampleType == ExampleType.ONE_USE) {
                    n4 += this.NEXT_LOCATION - 45;
                    n5 += this.NEXT_LOCATION - 45;
                    n6 += this.NEXT_LOCATION - 45;
                }
                graphics2D.drawLine(n, n4, n - 20, n5);
                graphics2D.drawLine(n, n4, n - 20, n6);
                int n7 = concurrentSprite.getType() == ConcurrentSprite.SpriteType.CAS ? 15 : 5;
                graphics2D.drawLine(n, n4, n - n7 * 6, n4);
                if (concurrentSprite.getType() == ConcurrentSprite.SpriteType.CAS) {
                    graphics2D.setColor(ConcurrentExampleConstants.CAS_ANIMATION_COLOR);
                    n3 = concurrentSprite.getValue();
                    if (n3 != ConcurrentSprite.NO_VALUE) {
                        String string = String.valueOf(n3);
                        graphics2D.drawString(string, n - 85, n4);
                    }
                }
                if ((n3 = concurrentSprite.getExpectedValue()) == ConcurrentSprite.NO_VALUE) break;
                graphics2D.drawString("(" + n3 + ")", n - 53, n4);
                break;
            }
            case OVAL: {
                graphics2D.fillOval(n - 85, n2, 90, 15);
            }
        }
        if (concurrentSprite.isActionCompleted()) {
            concurrentSprite.bumpLocationToDestination();
        }
        concurrentSprite.bumpCurrentLocation(DELTA);
        if (concurrentSprite.getCurrentLocation() >= concurrentSprite.getDestination()) {
            this.notifyListeners(ConcurrentAnimationEvent.ARRIVED, concurrentSprite);
        }
    }

    public void addListener(ConcurrentAnimationEvent concurrentAnimationEvent, PropertyChangeListener propertyChangeListener) {
        this.PROPERTY_CHANGE_SUPPORT.addPropertyChangeListener(concurrentAnimationEvent.toString(), propertyChangeListener);
    }

    public void removeListener(ConcurrentAnimationEvent concurrentAnimationEvent, PropertyChangeListener propertyChangeListener) {
        this.PROPERTY_CHANGE_SUPPORT.removePropertyChangeListener(concurrentAnimationEvent.toString(), propertyChangeListener);
    }

    private void notifyListeners(ConcurrentAnimationEvent concurrentAnimationEvent, ConcurrentSprite concurrentSprite) {
        this.PROPERTY_CHANGE_SUPPORT.firePropertyChange(concurrentAnimationEvent.toString(), concurrentSprite, null);
    }

    public void clearSprites() {
        this.sprites.clear();
    }

    public void shuffleSprites() {
        ArrayList<ConcurrentSprite> arrayList = new ArrayList<ConcurrentSprite>(this.sprites);
        Collections.shuffle(arrayList);
        this.sprites = new ConcurrentLinkedQueue<ConcurrentSprite>(arrayList);
    }
}

