/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.sprites;

import java.awt.Color;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.sprites.ConcurrentSpriteCanvas;

public class ConcurrentSprite {
    public static int NO_VALUE = Integer.MIN_VALUE;
    private SpriteState state = SpriteState.ACQUIRING;
    private SpriteType type = SpriteType.ARROW;
    private int index = 0;
    private int destination = 0;
    private int currentLocation = 0;
    private int value = NO_VALUE;
    private int expectedValue = NO_VALUE;
    private Color color = ConcurrentExampleConstants.ACQUIRING_COLOR;

    public ConcurrentSprite(int n, Color color) {
        this.index = n;
        this.color = color;
    }

    public ConcurrentSprite(int n) {
        this.index = n;
    }

    public void setAcquiring() {
        this.state = SpriteState.ACQUIRING;
        this.destination = ConcurrentSpriteCanvas.ACQUIRE_BORDER;
    }

    public void setAttempting() {
        this.setAcquiring();
        this.color = ConcurrentExampleConstants.ATTEMPTING_COLOR;
    }

    public void setActionCompleted() {
        this.state = SpriteState.ACTION_COMPLETED;
    }

    public void setAcquired() {
        this.state = SpriteState.ACQUIRED;
        this.destination = ConcurrentSpriteCanvas.RELEASE_BORDER;
        if (ConcurrentSpriteCanvas.exampleType == ExampleType.WORKING) {
            this.destination += 30;
        }
    }

    public void setReleased() {
        this.state = SpriteState.RELEASED;
        this.destination = Integer.MAX_VALUE;
        if (this.currentLocation < ConcurrentSpriteCanvas.ACQUIRE_BORDER) {
            this.currentLocation = ConcurrentSpriteCanvas.ACQUIRE_BORDER;
        }
    }

    public void setRejected() {
        this.state = SpriteState.REJECTED;
        this.color = ConcurrentExampleConstants.REJECTED_COLOR;
        this.destination = 0;
    }

    public SpriteState getState() {
        return this.state;
    }

    public SpriteType getType() {
        return this.type;
    }

    public void setType(SpriteType spriteType) {
        this.type = spriteType;
    }

    public int getIndex() {
        return this.index;
    }

    public int getDestination() {
        return this.destination;
    }

    public int getCurrentLocation() {
        return this.currentLocation;
    }

    public void bumpCurrentLocation(int n) {
        this.currentLocation += n;
        if (this.currentLocation > this.destination) {
            this.currentLocation = this.destination;
        } else if (this.currentLocation == this.destination) {
            this.currentLocation = this.destination - ConcurrentSpriteCanvas.BACK_DELTA;
        }
    }

    public void bumpLocationToDestination() {
        this.currentLocation = this.destination;
    }

    public void kickCurrentLocation(int n) {
        this.currentLocation -= n;
    }

    public void moveToAcquiringBorder() {
        this.currentLocation = ConcurrentSpriteCanvas.ACQUIRE_BORDER - 30;
    }

    public void moveToAcquiredBorder() {
        this.currentLocation = ConcurrentSpriteCanvas.ACQUIRE_BORDER;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isRejected() {
        return this.state == SpriteState.REJECTED;
    }

    public boolean isActionCompleted() {
        return this.state == SpriteState.ACTION_COMPLETED;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public int getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(int n) {
        this.expectedValue = n;
    }

    public static enum SpriteType {
        ARROW,
        OVAL,
        CAS;

    }

    public static enum SpriteState {
        ACQUIRING,
        ACQUIRED,
        RELEASED,
        REJECTED,
        ACTION_COMPLETED;

    }
}

