/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.work;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConnectionPool {
    private final Lock lock = new ReentrantLock();
    private final Condition hasConnections = this.lock.newCondition();
    private Condition belowMinimum = this.lock.newCondition();
    private final List<Connection> connections = new ArrayList<Connection>();
    private final int min;
    private final int refills;
    private boolean running;

    public ConnectionPool(int n, int n2) {
        this.output("ConnectionPool.run launching refill thread");
        this.min = n;
        this.refills = n2;
        this.running = true;
        this.launchRefillThread();
    }

    private void launchRefillThread() {
        Executors.defaultThreadFactory().newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (ConnectionPool.this.running) {
                        ConnectionPool.this.output("ConnectionPool.refill pool is full awaiting...");
                        ConnectionPool.this.lock.lock();
                        while (ConnectionPool.this.running && ConnectionPool.this.connections.size() >= ConnectionPool.this.min) {
                            ConnectionPool.this.belowMinimum.await();
                        }
                        ConnectionPool.this.output("ConnectionPool.refill need new connections.");
                        for (int i = 0; ConnectionPool.this.running && i < ConnectionPool.this.refills; ++i) {
                            Connection connection = ConnectionPool.this.createConnection();
                            ConnectionPool.this.connections.add(connection);
                            ConnectionPool.this.output("ConnectionPool.added");
                            ConnectionPool.this.hasConnections.signalAll();
                        }
                        ConnectionPool.this.lock.tryLock(1L, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    ConnectionPool.this.lock.unlock();
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.lock.lock();
            this.running = false;
            this.belowMinimum.signal();
        }
        finally {
            this.lock.unlock();
        }
        for (Connection connection : this.connections) {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() {
        Connection connection = null;
        this.lock.lock();
        try {
            while (this.connections.isEmpty()) {
                this.output("ConnectionPool.getConnection no connections. Awaiting connections...");
                this.hasConnections.await();
            }
            if (this.running) {
                connection = this.connections.remove(0);
            }
            this.belowMinimum.signal();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
        this.output("ConnectionPool.getConnection received a connection");
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Connection connection) {
        try {
            this.lock.lock();
            this.connections.add(connection);
            this.hasConnections.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void main(String[] stringArray) throws InterruptedException {
        final ConnectionPool connectionPool = new ConnectionPool(5, 3);
        Executors.defaultThreadFactory().newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    connectionPool.output("Stopping...");
                    connectionPool.stop();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }).start();
        connectionPool.test();
    }

    private void test() throws InterruptedException {
        int n = 10;
        for (int i = 0; i < n; ++i) {
            Thread.sleep(5000L);
            this.output("Connection.main requesting connections");
            Connection connection = this.getConnection();
            this.output("Connection.main connection obtained: " + connection);
        }
    }

    private void output(String string) {
        System.out.println(new Date() + " " + string + ". connections:" + this.connections.size());
    }

    private Connection createConnection() {
        return new Connection();
    }

    class Connection {
        Date creation = new Date();

        public Connection() {
            long l = (long)(1000.0 * (1.0 + Math.random()));
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }

        public String toString() {
            return "Connection " + this.creation;
        }

        public void close() {
        }
    }
}

