/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JButton;
import javax.swing.JTextField;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class ReentrantLockExample
extends ConcurrentExample {
    private Lock lock;
    private static final Object MUTEX = new Object();
    private final JButton acquireButton = new JButton("lock");
    private final JButton releaseButton = new JButton("unlock");
    private final JButton attemptButton = new JButton("tryLock");
    private boolean initialized = false;
    private static final int MIN_SNIPPET_POSITION = 300;
    private final JTextField threadCountField = this.createThreadCountField();

    @Override
    public String getTitle() {
        return "ReentrantLock";
    }

    @Override
    protected String getSnippet() {
        String string = "<html><PRE><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\">    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Constructor</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\">final</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"><B> Lock lock = </B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> ReentrantLock(); \n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#808080>\"><I>// Locking Thread - Once a Lock is acquired this<br>    // thread blocks until another thread calls unlock.</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> \n       lock.lock(); \n<font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\">\n       // lock unblocks and work continues... \n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#808080>\"><I>// Unlocking Thread - All waiting threads are<br>    // notified when lock is released. Then one is<br>    // selected at random to acquire the lock.</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> \n      </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\">\n lock.unlock(); \n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#808080>\"><I>// Try Lock Thread - All waiting threads are<br>    // notified when lock is released. Then one is<br>    // selected at random to acquire the lock.</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> \n       </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\">try</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> { \n         lock.tryLock(1000L, TimeUnit.MILLISECONDS</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">); \n<font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\">\n       // lock unblocks and work continues... \n       </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>} catch</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">(InterruptedException e) { \n         Thread.currentThread().interrupt(); \n       } \n     }</FONT></PRE></html>";
        return string;
    }

    public ReentrantLockExample(String string, Container container, int n) {
        super(string, container, ExampleType.BLOCKING, 300, false, n);
    }

    @Override
    protected void initializeComponents() {
        if (!this.initialized) {
            this.initializeButton(this.acquireButton, new Runnable(){

                @Override
                public void run() {
                    int n = ReentrantLockExample.this.getThreadCount(ReentrantLockExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        ReentrantLockExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                ReentrantLockExample.this.acquire();
                            }
                        });
                    }
                }
            });
            this.initializeButton(this.releaseButton, new Runnable(){

                @Override
                public void run() {
                    int n = ReentrantLockExample.this.getThreadCount(ReentrantLockExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        ReentrantLockExample.this.release();
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            });
            this.initializeButton(this.attemptButton, new Runnable(){

                @Override
                public void run() {
                    int n = ReentrantLockExample.this.getThreadCount(ReentrantLockExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        ReentrantLockExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                ReentrantLockExample.this.attempt();
                            }
                        });
                    }
                }
            });
            this.initializeThreadCountField(this.threadCountField);
            this.initialized = true;
        }
    }

    private void acquire() {
        this.setAnimationCanvasVisible(true);
        this.setState(1);
        this.message1(new Date() + " Waiting for acquire...", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
        this.message2(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        ConcurrentSprite concurrentSprite = this.createAcquiringSprite();
        this.lock.lock();
        concurrentSprite.setAcquired();
        this.setAcquiredSprite(concurrentSprite);
        this.message1(new Date() + " Acquired", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.waitForUnlockNotification();
    }

    private void attempt() {
        try {
            this.setState(3);
            this.message1("Attempting acquire..", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
            this.message2(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
            ConcurrentSprite concurrentSprite = this.createAttemptingSprite();
            if (this.lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                this.message1("Acquire attempt succeeded", ConcurrentExampleConstants.MESSAGE_COLOR);
                concurrentSprite.setAcquired();
                this.setAcquiredSprite(concurrentSprite);
                this.waitForUnlockNotification();
            } else {
                this.message1("Acquire attempt failed", ConcurrentExampleConstants.ERROR_MESSAGE_COLOR);
                concurrentSprite.setRejected();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForUnlockNotification() {
        Object object = MUTEX;
        synchronized (object) {
            try {
                MUTEX.wait();
                this.lock.unlock();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        this.setState(2);
        this.message2(new Date() + " Waiting for release ", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
        ReentrantLockExample reentrantLockExample = this;
        synchronized (reentrantLockExample) {
            Object object = MUTEX;
            synchronized (object) {
                MUTEX.notify();
            }
            object = this.acquiredSprite;
            if (object != null) {
                ((ConcurrentSprite)object).setReleased();
                this.setAcquiredSprite(null);
            }
            this.message2(new Date() + " Released", ConcurrentExampleConstants.MESSAGE_COLOR);
        }
        this.setState(2);
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    protected void reset() {
        this.lock = new ReentrantLock();
        this.message1(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.message2(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.resetThreadCountField(this.threadCountField);
        this.setState(0);
        super.reset();
    }
}

