/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteLockTester {
    final ExecutorService pool = Executors.newCachedThreadPool();
    ReentrantReadWriteLock rwlock;
    private final Object mutex = new Object();

    public static void main(String[] stringArray) {
        new ReadWriteLockTester();
    }

    public ReadWriteLockTester() {
        boolean bl = true;
        this.rwlock = new ReentrantReadWriteLock(true);
        try {
            System.out.println("ReadWriteLockTester.ReadWriteLockTester fair:" + this.rwlock.isFair());
            this.readLock();
            this.writeLock();
            this.readLock();
            this.writeLock();
            this.readLock();
            this.writeLock();
            Thread.sleep(3000L);
            this.wakeRead();
            this.wakeRead();
            this.wakeRead();
            Thread.sleep(3000L);
            System.exit(1);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeRead() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notify();
        }
    }

    private void readLock() {
        this.pool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ReadWriteLockTester.this.rwlock.readLock().lock();
                System.out.println("ConcurrentExampleLauncher.run " + this + " acquired ReadLock");
                Object object = ReadWriteLockTester.this.mutex;
                synchronized (object) {
                    try {
                        ReadWriteLockTester.this.mutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                System.out.println("ConcurrentExampleLauncher.run " + this + " releasing ReadLock");
                ReadWriteLockTester.this.rwlock.readLock().unlock();
            }
        });
    }

    private void writeLock() {
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(0L);
                    System.out.println("ReadWriteLockTester.run acquiring write lock");
                    ReadWriteLockTester.this.rwlock.writeLock().lock();
                    System.out.println("ConcurrentExampleLauncher.run " + this + " acquired WriteLock");
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }
}

