/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class AtomicIntegerExampleOrig
extends ConcurrentExample {
    private AtomicInteger atomicVariable;
    private int value = 3;
    private final JButton incrementButton = new JButton("Increment");
    private final JButton commitButton = new JButton("compareAndSet");
    private boolean initialized = false;

    @Override
    public String getTitle() {
        return "AtomicInteger";
    }

    @Override
    protected String getSnippet() {
        String string = "<html><PRE>\n<FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Construct the AtomicVariable with the initial value</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000080\"><B>final</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> AtomicInteger atomicVariable = </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000080\"><B>new</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> AtomicInteger(</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#0000ff\">0</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\">); \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Arithmetic functions such as add, subtract, multiply,</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// divide, perform their function in an atomic fashion</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// and return the result.</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000080\"><B>final</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000080\"><B>int</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> result = atomicVariable.incrementAndGet(</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#0000ff\">3</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\">); \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// compareAndSet does an atomic &quot;check and set if&quot;.</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Value is only set if the original value == assumedValue</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000080\"><B>int</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> assumedValue = </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#0000ff\">10</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\">, newValue = </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#0000ff\">5</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\">; \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000080\"><B>boolean</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> success = atomicVariable.compareAndSet(assumedValue, newValue); \n \n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n</PRE></html>";
        return string;
    }

    public AtomicIntegerExampleOrig(String string, Container container, int n) {
        super(string, container, ExampleType.BLOCKING, 390, false, n);
    }

    @Override
    protected ConcurrentSprite createAcquiringSprite() {
        int n = this.atomicVariable.incrementAndGet();
        this.message1("Index after increment call:" + n, ConcurrentExampleConstants.MESSAGE_COLOR);
        ConcurrentSprite concurrentSprite = new ConcurrentSprite(n);
        concurrentSprite.setAcquiring();
        this.getAnimationCanvas().addSprite(concurrentSprite);
        return concurrentSprite;
    }

    @Override
    protected void initializeComponents() {
        if (!this.initialized) {
            this.initializeButton(this.incrementButton, new Runnable(){

                @Override
                public void run() {
                    AtomicIntegerExampleOrig.this.setAnimationCanvasVisible(true);
                    ConcurrentSprite concurrentSprite = AtomicIntegerExampleOrig.this.createAcquiringSprite();
                    concurrentSprite.setAcquired();
                    AtomicIntegerExampleOrig.this.setAcquiredSprite(concurrentSprite);
                }
            });
            this.initializeButton(this.commitButton, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicIntegerExampleOrig atomicIntegerExampleOrig = AtomicIntegerExampleOrig.this;
                    synchronized (atomicIntegerExampleOrig) {
                        boolean bl = AtomicIntegerExampleOrig.this.atomicVariable.compareAndSet(10, 5);
                        if (bl) {
                            AtomicIntegerExampleOrig.this.message2("atomicVariable.compareAndSet(10, 5) Commited", ConcurrentExampleConstants.MESSAGE_COLOR);
                        } else {
                            AtomicIntegerExampleOrig.this.message2("atomicVariable.compareAndSet(10, 5) NOT Commited", ConcurrentExampleConstants.ERROR_MESSAGE_COLOR);
                        }
                    }
                }
            });
            this.initialized = true;
        }
        this.reset();
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    protected void reset() {
        this.value = 3;
        this.atomicVariable = new AtomicInteger(this.value);
        this.message1(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.message2(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.setState(0);
        super.reset();
    }
}

