/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JButton;
import javax.swing.JTextField;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class CompletionServiceExample
extends ConcurrentExample {
    private boolean initialized;
    private final JButton submitButton = new JButton("submit");
    private final JButton takeButton = new JButton("take().get()");
    private CompletionService<Result> completionService;
    private int index;
    private int RESET_COUNT = 0;
    private JTextField threadCountField = this.createThreadCountField();

    public CompletionServiceExample(String string, Container container, int n) {
        super(string, container, ExampleType.BLOCKING, 390, false, n);
    }

    @Override
    public String getTitle() {
        return "CompletionService";
    }

    @Override
    protected void initializeComponents() {
        this.reset();
        if (!this.initialized) {
            this.initializeButton(this.submitButton, new Runnable(){

                @Override
                public void run() {
                    CompletionServiceExample.this.setState(1);
                    int n = CompletionServiceExample.this.getThreadCount(CompletionServiceExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        CompletionServiceExample.this.submit();
                    }
                }
            });
            this.initializeButton(this.takeButton, new Runnable(){

                @Override
                public void run() {
                    CompletionServiceExample.this.setState(2);
                    int n = CompletionServiceExample.this.getThreadCount(CompletionServiceExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        CompletionServiceExample.this.take();
                    }
                }
            });
            this.initializeThreadCountField(this.threadCountField);
            this.initialized = true;
        }
    }

    private void submit() {
        final ConcurrentSprite concurrentSprite = this.createAcquiringSprite(ConcurrentSprite.SpriteType.ARROW);
        final Result result = new Result(this.index++, concurrentSprite, this.RESET_COUNT);
        Callable<Result> callable = new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                CompletionServiceExample.this.setSpriteAcquired(result);
                long l = (long)(1000.0 + Math.random() * 2000.0);
                Thread.sleep(l);
                if (result.resetCount == CompletionServiceExample.this.RESET_COUNT) {
                    CompletionServiceExample.this.message2("Calculation " + result.index + " complete", ConcurrentExampleConstants.MESSAGE_COLOR);
                }
                concurrentSprite.setActionCompleted();
                return result;
            }
        };
        this.solve(callable);
    }

    private void solve(Callable<Result> callable) {
        this.completionService.submit(callable);
    }

    private void take() {
        try {
            long l = System.currentTimeMillis();
            Future<Result> future = this.completionService.take();
            Result result = future.get();
            long l2 = System.currentTimeMillis();
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l;
            long l5 = l2 - l;
            if (l4 != l5) {
                System.out.println("get: " + l5 + " end:" + l4);
            }
            this.setSpriteReleased(result);
            this.use(result);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
    }

    private void setSpriteAcquired(Result result) {
        ConcurrentSprite concurrentSprite = result.getSprite();
        concurrentSprite.setAcquired();
    }

    private void setSpriteReleased(Result result) {
        ConcurrentSprite concurrentSprite = result.getSprite();
        concurrentSprite.setReleased();
    }

    private void use(Result result) {
        this.message1("CompletionServiceExample.use: received result:" + result, ConcurrentExampleConstants.MESSAGE_COLOR);
    }

    @Override
    public String getDescriptionHtml() {
        return "";
    }

    @Override
    public void reset() {
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        this.completionService = new ExecutorCompletionService<Result>(executorService);
        this.index = 0;
        ++this.RESET_COUNT;
        this.resetThreadCountField(this.threadCountField);
        this.message1("  ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.message2("  ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.setState(0);
        super.reset();
    }

    @Override
    protected String getSnippet() {
        String string = "<html><pre>\n<FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"> \n    // Launch multiple Callables in a completion service.\n    // Results are queued as they arrive. \n    // To retrieve the results in sequence, \n    // call completionService.take().get(); \n \n<FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>    // Create a completionService, providing an Executor \n    // in the constructor. \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"><B>final</B> CompletionService<Result> completionService = \n <B>    new</B> ExecutorCompletionService<Result>( \n        Executors.newFixedThreadPool(4)); \n \n<FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>    // Submit callables to the completion service \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">completionService.submit(callable);</FONT> \n \n<FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>    // Now take results in the order they complete \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\">Future<Result> future = completionService.take();</FONT>\n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\">Result result = future.get();</FONT> \n \n \n \n \n \n \n \n \n</PRE></html>";
        return string;
    }

    class Result {
        private final int index;
        private final ConcurrentSprite sprite;
        private int resetCount;

        public Result(int n, ConcurrentSprite concurrentSprite, int n2) {
            this.index = n;
            this.sprite = concurrentSprite;
            this.resetCount = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public ConcurrentSprite getSprite() {
            return this.sprite;
        }

        public String toString() {
            return "Result:" + this.index;
        }
    }
}

