/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.sprites;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;
import vgrazi.concurrent.samples.sprites.ConcurrentSpriteCanvas;
import vgrazi.concurrent.samples.util.UIUtils;

public class TestSpriteEngine {
    private final ConcurrentSpriteCanvas canvas = new ConcurrentSpriteCanvas(null, "");
    private final AtomicInteger acquiring = new AtomicInteger(0);
    private final Stack acquiringSprites = new Stack();
    private final Stack acquiredSprites = new Stack();

    public static void main(String[] stringArray) {
        new TestSpriteEngine().test();
    }

    private void test() {
        JFrame jFrame = new JFrame("Concurrent Sprite Test");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)this.canvas, "Center");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(800, 400);
        UIUtils.center(jFrame);
        JPanel jPanel = this.createButtonPanel();
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.show();
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        JButton jButton = new JButton("Acquiring");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TestSpriteEngine.this.acquiring.incrementAndGet();
                ConcurrentSprite concurrentSprite = new ConcurrentSprite(n);
                concurrentSprite.setAcquiring();
                TestSpriteEngine.this.acquiringSprites.push(concurrentSprite);
                TestSpriteEngine.this.canvas.addSprite(concurrentSprite);
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("Acquired");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConcurrentSprite concurrentSprite = (ConcurrentSprite)TestSpriteEngine.this.acquiringSprites.pop();
                TestSpriteEngine.this.acquiredSprites.push(concurrentSprite);
                concurrentSprite.setAcquired();
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("Released");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TestSpriteEngine.this.acquiredSprites.empty()) {
                    ConcurrentSprite concurrentSprite = (ConcurrentSprite)TestSpriteEngine.this.acquiredSprites.pop();
                    concurrentSprite.setReleased();
                }
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }
}

