/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JTextField;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class CountDownLatchExample
extends ConcurrentExample {
    private CountDownLatch countDownLatch;
    private final JButton acquireButton = new JButton("await");
    private final JButton releaseButton = new JButton("countDown");
    private final JButton attemptButton = new JButton("await(timeMS, TimeUnit.MILLISECONDS)");
    private int index;
    private boolean initialized = false;
    private final JTextField threadCountField = this.createThreadCountField();
    private static final int MIN_SNIPPET_POSITION = 360;

    @Override
    public String getTitle() {
        return "CountDownLatch";
    }

    public CountDownLatchExample(String string, Container container, int n) {
        super(string, container, ExampleType.WORKING, 360, false, n);
    }

    @Override
    protected void initializeComponents() {
        this.reset();
        if (!this.initialized) {
            this.initializeButton(this.acquireButton, new Runnable(){

                @Override
                public void run() {
                    CountDownLatchExample.this.setAnimationCanvasVisible(true);
                    int n = CountDownLatchExample.this.getThreadCount(CountDownLatchExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        CountDownLatchExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                CountDownLatchExample.this.acquire();
                            }
                        });
                    }
                }
            });
            this.initializeButton(this.releaseButton, new Runnable(){

                @Override
                public void run() {
                    int n = CountDownLatchExample.this.getThreadCount(CountDownLatchExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        CountDownLatchExample.this.release();
                    }
                }
            });
            this.initializeButton(this.attemptButton, new Runnable(){

                @Override
                public void run() {
                    int n = CountDownLatchExample.this.getThreadCount(CountDownLatchExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        CountDownLatchExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                CountDownLatchExample.this.attempt();
                            }
                        });
                    }
                }
            });
            this.initializeThreadCountField(this.threadCountField);
            this.initialized = true;
        }
    }

    private void attempt() {
        try {
            this.setState(3);
            this.message1("Attempting acquire..", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
            ConcurrentSprite concurrentSprite = this.createAttemptingSprite();
            if (this.countDownLatch.await(3000L, TimeUnit.MILLISECONDS)) {
                this.message1("Acquire attempt succeeded", ConcurrentExampleConstants.MESSAGE_COLOR);
                concurrentSprite.setReleased();
            } else {
                this.message1("Acquire attempt failed", ConcurrentExampleConstants.ERROR_MESSAGE_COLOR);
                concurrentSprite.setRejected();
            }
            this.setState(3);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void release() {
        this.setState(2);
        int n = this.index++;
        this.message2("Attempting release " + n, ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
        this.countDownLatch.countDown();
        this.createReleasingSprite();
        this.message2("Released index " + n, ConcurrentExampleConstants.MESSAGE_COLOR);
        this.setState(2);
    }

    private void acquire() {
        try {
            this.message1("Waiting for acquire...", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
            this.setState(1);
            ConcurrentSprite concurrentSprite = this.createAcquiringSprite();
            this.countDownLatch.await();
            concurrentSprite.setReleased();
            this.message1("Acquired", ConcurrentExampleConstants.MESSAGE_COLOR);
            this.setState(1);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    protected void reset() {
        super.reset();
        this.countDownLatch = new CountDownLatch(4);
        this.index = 1;
        this.resetThreadCountField(this.threadCountField);
        this.message1(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.message2(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.setState(0);
    }

    @Override
    protected String getSnippet() {
        return "<html><PRE>\n<font style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n \n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Constructor - pass in the pass count</I></FONT><font style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>final</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> CountDownLatch countDownLatch = </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\">\n\n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\">        <B>new</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> CountDownLatch(4); \n \n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Threads attempting to acquire will block</I></FONT><font style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// until the specified number of releases are counted</I></FONT><font style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\">Thread acquireThread = </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>new</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> Thread(</FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>new</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> Runnable() { \n      </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>public</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>void</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> run() { \n        </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>try</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> { \n          countDownLatch.await(); \n        } </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>catch</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">(InterruptedException e) { }\n \n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\">Thread releaseThread = </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>new</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> Thread(</FONT><font style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>new</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> Runnable() { \n      </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>public</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>void</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> run() { \n        countDownLatch.countDown(); \n      } \n \n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// timed await is like await except that it</I></FONT><font style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// times out after the specified timeout period</I></FONT><font style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n      </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>try</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> { \n        countDownLatch.await(1000L, TimeUnit.MILLISECONDS)</FONT><font style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">); \n      } </FONT><font style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>catch</B></FONT><font style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">(InterruptedException e) { }\n</FONT></PRE></html>";
    }
}

