/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.examples.ConcurrentExample;

public class ImagePanel
extends JPanel {
    private int yOverride = 0;
    private ConcurrentExample concurrentExample;
    private int xPos;
    private int yPos;
    private String imageName;
    private static final Logger logger = Logger.getLogger(ImagePanel.class.getName());

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public ImagePanel(String string) {
        this((ConcurrentExample)null);
        this.imageName = string;
    }

    public ImagePanel(ConcurrentExample concurrentExample) {
        this.setLayout(new BorderLayout());
        this.concurrentExample = concurrentExample;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ImagePanel.this.concurrentExample != null && ImagePanel.this.concurrentExample.getAnimationCanvas().isVisible()) {
                    ImagePanel.this.xPos = mouseEvent.getX();
                    ImagePanel.this.yPos = mouseEvent.getY();
                    logger.log(Level.INFO, "ConcurrentSpriteCanvas.mousePressed " + mouseEvent);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    ImagePanel.this.toggleView();
                    logger.log(Level.INFO, "ConcurrentSpriteCanvas.mouseDouble Clicked " + mouseEvent);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (ImagePanel.this.concurrentExample != null && ImagePanel.this.concurrentExample.getAnimationCanvas().isVisible()) {
                    int n = mouseEvent.getX() - ImagePanel.this.xPos;
                    int n2 = mouseEvent.getY() - ImagePanel.this.yPos;
                    ImagePanel.this.xPos = mouseEvent.getX();
                    ImagePanel.this.yPos = mouseEvent.getY();
                    Point point = ImagePanel.this.concurrentExample.getAnimationCanvas().getLocation();
                    ImagePanel.this.concurrentExample.getAnimationCanvas().setLocation((int)point.getX() + n, (int)(point.getY() + (double)n2));
                    logger.log(Level.INFO, "ConcurrentSpriteCanvas.mouseDragged " + mouseEvent);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 1 && ImagePanel.this.concurrentExample != null) {
                    ImagePanel.this.concurrentExample.setAnimationCanvasVisible(true);
                }
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 9));
        jPanel.setOpaque(false);
        ImageIcon imageIcon = new ImageIcon("CENTER:\\dev\\concurrent\\concurrent\\classes\\images\\button.gif");
        JButton jButton = new JButton(imageIcon);
        jButton.setOpaque(false);
        jButton.setBorderPainted(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setBackground(Color.BLUE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (++ConcurrentExampleConstants.imageIndex >= ConcurrentExampleConstants.SLIDES.length) {
                    ConcurrentExampleConstants.imageIndex = 0;
                }
                ImagePanel.this.add(new JLabel(new ImageIcon(ImagePanel.this.imageName)));
                ImagePanel.this.redoLayout();
            }
        });
        this.addSpacers(jPanel);
        jPanel.add(jButton);
        this.addSpacers(jPanel);
        this.add((Component)jPanel, "South");
    }

    public void toggleView() {
        if (this.concurrentExample != null) {
            if (this.concurrentExample.getAnimationCanvas().isVisible()) {
                this.setImageView();
            } else {
                this.setExampleView();
            }
        } else {
            this.setImageView();
        }
    }

    private void redoLayout() {
        this.getParent().doLayout();
        this.getParent().validate();
    }

    public void setExampleView() {
        if (this.concurrentExample != null) {
            this.concurrentExample.setVisible(true);
            this.concurrentExample.setButtonsVisible(true);
        }
        this.setVisible(false);
    }

    public void setImageView() {
        if (this.concurrentExample != null) {
            this.concurrentExample.setVisible(false);
            this.concurrentExample.setButtonsVisible(false);
        }
        this.setVisible(true);
    }

    private void addSpacers(JPanel jPanel) {
        for (int i = 0; i < 4; ++i) {
            this.addSpacer(jPanel);
        }
    }

    private void addSpacer(JPanel jPanel) {
        jPanel.add(new JLabel());
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.yOverride == 0 || this.yOverride > n2) {
            super.setBounds(n, n2, n3, n4);
            this.yOverride = n2;
        } else {
            super.setBounds(n, this.yOverride, n3, n4);
        }
    }
}

